$("document").ready(function() {
    $("#js-warning").addClass("hidden");

    // trigger onchange once (the browser may have saved something)
    $("#points").change();
    $("#m5").change();
});

function update_points() {
    if ($("#points").val() == "")
        return;
    if (!/[-\d]/.test($("#points").val())) {
        $("#warn-points-nnr").removeClass("hidden");
        return;
    }
    if ($("#points").val() < 0 || $("#points").val() > 900) {
        $("#warn-points-oor").removeClass("hidden");
        return;
    }
    $("#warn-points-nnr").addClass("hidden");
    $("#warn-points-oor").addClass("hidden");
    update();
}

function update_m5() {
    if ($("#m5").val() == "")
        return;
    if (!/[-\d]/.test($("#m5").val())) {
        $("#warn-m5-nnr").removeClass("hidden");
        return;
    }
    if ($("#m5").val() < 0 || $("#m5").val() > 15) {
        $("#warn-m5-oor").removeClass("hidden");
        return;
    }
    $("#warn-m5-nnr").addClass("hidden");
    $("#warn-m5-oor").addClass("hidden");
    update();
}

function update_eem() {
    if ($("#eem").val() == "")
        return;
    if (!/[-\d]/.test($("#eem").val())) {
        $("#warn-eem-nnr").removeClass("hidden");
        return;
    }
    if ($("#eem").val() < 1 || $("#eem").val() > 6) {
        $("#warn-eem-oor").removeClass("hidden");
        return;
    }
    $("#warn-eem-nnr").addClass("hidden");
    $("#warn-eem-oor").addClass("hidden");
    $("#eep").val(mark_to_points($("#eem").val()).toFixed(0));
    update();
}

function update_eep() {
    if ($("#eep").val() == "")
        return;
    if (!/[-\d]/.test($("#eep").val())) {
        $("#warn-eep-nnr").removeClass("hidden");
        return;
    }
    if ($("#eep").val() < 0 || $("#eep").val() > 900) {
        $("#warn-eep-oor").removeClass("hidden");
        return;
    }
    $("#warn-eep-nnr").addClass("hidden");
    $("#warn-eep-oor").addClass("hidden");
    $("#eem").val(points_to_mark($("#eep").val()));
    update();
}

function update_points_written() {
    if ($("#points_written").val() == "")
        return;
    if (!/[-\d]/.test($("#points_written").val())) {
        $("#warn-points_written-nnr").removeClass("hidden");
        return;
    }
    if ($("#points_written").val() < 0 || $("#points_written").val() > 15) {
        $("#warn-points_written-oor").removeClass("hidden");
        return;
    }
    $("#warn-points_written-nnr").addClass("hidden");
    $("#warn-points_written-oor").addClass("hidden");
    update();
}

function update() {
    var start_points = parseInt($("#points").val());
    var m5_points = parseInt($("#m5").val());

    $("#prev-body .prev-cntn").remove();
    var last_res_mark = points_to_mark(start_points);
    for (var i = 0; i <= 15; i++) {
        var clone = $("#prev-template").clone(true).attr("id", "").removeClass("hidden").addClass("prev-cntn");

        var new_res_mark = points_to_mark(start_points + pmark_to_points(i));
        if (last_res_mark != new_res_mark) {
            clone.addClass("bg-success");
        }
        last_res_mark = new_res_mark;
        clone.find(".prev-mark").html(i);
        clone.find(".prev-points").html(start_points + pmark_to_points(i));
        clone.find(".prev-res-mark").html(new_res_mark);
        clone.find(".prev-btn-choose").click(function() {
            $("#m5").val((this.parentElement.parentElement.getElementsByClassName("prev-mark")[0].innerHTML));
            $("#m5").change();
        });
        clone.appendTo("#prev-body");
    }
    var current_points = start_points + pmark_to_points(m5_points);
    if (!isNaN(current_points)) {
        $("#m5-res").html(current_points + " / " + points_to_mark(current_points));
    } else {
        $("#m5-res").html("-");
    }

    var eep = parseInt($("#eep").val());
    var points_written = parseInt($("#points_written").val());
    var required_mark = required_pmark(current_points, eep, points_written).toFixed(0);

    if (!isNaN(required_mark)) {
        $("#extra_p").html(required_mark);
        if (required_mark <= 0) {
            $("#extra_p_comment").html("(Prüfung nicht notwendig)");
        } else if (required_mark > 15) {
            var max_pos_points = required_pmark_max(current_points, 15, points_written);
            $("#extra_p_comment").html("(Wunschnote nicht möglich, bestes Ergebnis ist " + max_pos_points + " / " + points_to_mark(max_pos_points) + ")");
        } else {
            $("#extra_p_comment").html("");
        }
    } else {
        $("#extra_p").html("-");
        $("#extra_p_comment").html("");
    }
}

function points_to_mark(points) {
    var mark = 17.0 / 3.0 - points / 180.0;
    mark = Math.floor(mark * 10)/10;
    return mark >= 1 ? mark : 1;
}

function mark_to_points(mark) {
    mark = +(mark) + 0.1;
    var points = 180 * (17.0 / 3.0 - mark);
    points += 1;
    return points > 0 ? points : 0;
}

function pmark_to_points(mark) {
    return 4 * mark
}

function required_pmark(points, target, written_makr) {
    return 3 * (target - points + 4 * written_makr) / 4 - 2 * written_makr;
}

function required_pmark_max(points, spoken_mark, written_makr) {
    return ((4 * spoken_mark - 4 * written_makr) / 3 + points).toFixed(0);
}
